<?php
/**
 * Plugin Name: WooCommerce Payment History Table
 * Description: Displays a table of WooCommerce payment history for customers with a shortcode.
 * Version: 1.0
 * Author: Your Name
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Create a shortcode [payment_history_table] to display the table
function wc_payment_history_table_shortcode()
{
    if (!is_user_logged_in()) {
        return '<p>Please log in to view your payment history.</p>';
    }

    $customer_id = get_current_user_id();
    $orders = wc_get_orders([
        'customer' => $customer_id,
        'limit' => -1, // Fetch all orders
        'orderby' => 'date',
        'order' => 'DESC',
    ]);

    if (empty($orders)) {
        return '<p>No payment history found.</p>';
    }

    // Start outputting the table
    $output = '<table style="width: 100%; border-collapse: collapse; margin-top: 20px;">';
    $output .= '<tr style="background-color: #f4f4f4; text-align: left;">';
    $output .= '<th style="padding: 8px; border: 1px solid #ddd;">Order ID</th>';
    $output .= '<th style="padding: 8px; border: 1px solid #ddd;">Payment Date</th>';
    $output .= '<th style="padding: 8px; border: 1px solid #ddd;">Amount</th>';
    $output .= '<th style="padding: 8px; border: 1px solid #ddd;">Payment Status</th>';
    $output .= '</tr>';

    foreach ($orders as $order) {
        $order_id = $order->get_id();
        $payment_date = $order->get_date_paid() ? $order->get_date_paid()->date('Y-m-d H:i:s') : 'Not Paid';
        $amount = $order->get_total(); // Retrieve the plain total amount
        $currency = get_woocommerce_currency_symbol(); // Get the currency symbol
        $status = wc_get_order_status_name($order->get_status());

        $output .= '<tr>';
        $output .= '<td style="padding: 8px; border: 1px solid #ddd;">' . esc_html($order_id) . '</td>';
        $output .= '<td style="padding: 8px; border: 1px solid #ddd;">' . esc_html($payment_date) . '</td>';
        $output .= '<td style="padding: 8px; border: 1px solid #ddd;">' . esc_html($currency . ' ' . $amount) . '</td>';
        $output .= '<td style="padding: 8px; border: 1px solid #ddd;">' . esc_html($status) . '</td>';
        $output .= '</tr>';
    }

    $output .= '</table>';

    return $output;
}

// Register the shortcode
add_shortcode('payment_history_table', 'wc_payment_history_table_shortcode');
